/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.autoplot.AppManager;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.scriptconsole.GuiExceptionHandler;
import org.das2.DasApplication;
import org.das2.datum.LoggerManager;
import org.das2.util.AboutUtil;

public final class EventThreadResponseMonitor {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.splash");
    private long lastPost;
    private long response;
    private Thread eventQueue;
    private final Map<String, Object> map = new HashMap<String, Object>();
    private static final int TEST_CLEAR_EVENT_QUEUE_PERIOD_MILLIS = 300;
    private static final int WARN_LEVEL_MILLIS = 500;
    private static final int ERROR_LEVEL_MILLIS = 10000;
    private static final int WATCH_INTERVAL_MILLIS = 1000;
    private static final File LOG_DIR = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "log");
    private static final File REQUEST_DUMP_FILE = new File(LOG_DIR, "request_dump.txt");
    ScheduledThreadPoolExecutor exec;
    AWTEvent currentEvent = null;
    String reportedEventId = "";
    boolean pleasePostEvent = true;
    PrintStream outs = null;

    public EventThreadResponseMonitor() {
        this.lastPost = System.currentTimeMillis();
    }

    public void start() {
        logger.info("Starting EventThreadResponseMonitor, which should have a trivial effect on performance.");
        logger.log(Level.INFO, "Warnings will be written to {0}", new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "log"));
        this.exec = new ScheduledThreadPoolExecutor(1);
        this.exec.scheduleAtFixedRate(this.maybeCreateEventThreadRunnable(), 4000L, 300L, TimeUnit.MILLISECONDS);
        this.exec.scheduleAtFixedRate(this.checkEventThreadRunnable(), 4000L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void setLogFile(File f) {
        if (this.outs != null) {
            this.outs.close();
        }
        if (f != null) {
            try {
                this.outs = new PrintStream(new FileOutputStream(f));
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    public void addToMap(String key, Object value) {
        this.map.put(key, value);
    }

    public static synchronized String dumpPendingEvents() {
        StringBuilder buf = new StringBuilder();
        LinkedList<AWTEvent> queue = new LinkedList<AWTEvent>();
        EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (instance.peekEvent() != null) {
            buf.append("---------------------------------------------------------------\n");
        }
        while (instance.peekEvent() != null) {
            AWTEvent evt;
            try {
                evt = instance.getNextEvent();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            buf.append(evt).append("\n");
            queue.add(evt);
        }
        if (instance.peekEvent() != null) {
            buf.append("-----e--n--d-----------------------------------------------------");
        }
        while (queue.size() > 0) {
            instance.postEvent((AWTEvent)queue.remove());
        }
        return buf.toString();
    }

    private Runnable maybeCreateEventThreadRunnable() {
        return () -> {
            EventThreadResponseMonitor eventThreadResponseMonitor = this;
            synchronized (eventThreadResponseMonitor) {
                if (this.pleasePostEvent) {
                    this.pleasePostEvent = false;
                    this.lastPost = System.currentTimeMillis();
                    SwingUtilities.invokeLater(this.responseRunnable(""));
                }
            }
        };
    }

    private Runnable responseRunnable(String pending) {
        return () -> {
            this.response = System.currentTimeMillis();
            long levelms = this.response - this.lastPost;
            if (this.outs != null) {
                this.outs.println(String.format("%16d %d", this.response, levelms));
            }
            this.eventQueue = Thread.currentThread();
            if (levelms > 500L) {
                logger.log(Level.FINE, "CURRENT EVENT QUEUE CLEAR TIME: {0} sec\n", levelms / 1000L);
                if (pending != null) {
                    logger.log(Level.FINE, "events pending:\n");
                    logger.log(Level.FINE, pending);
                }
            }
            this.pleasePostEvent = true;
            logger.log(Level.FINER, "eventQueue clear time: {0}", levelms);
        };
    }

    private boolean checkRequestDump() {
        if (!LOG_DIR.exists()) {
            return false;
        }
        return REQUEST_DUMP_FILE.exists();
    }

    private Runnable checkEventThreadRunnable() {
        return () -> {
            EventQueue instance = Toolkit.getDefaultToolkit().getSystemEventQueue();
            AWTEvent test = instance.peekEvent();
            boolean dumpRequested = this.checkRequestDump();
            if (dumpRequested || this.currentEvent != null && test == this.currentEvent) {
                boolean hungProcess;
                logger.log(Level.FINE, "====  long job to process ====");
                logger.log(Level.FINE, test == null ? "NULL" : test.toString());
                logger.log(Level.FINE, "====  end, long job to process ====");
                if (dumpRequested) {
                    if (!REQUEST_DUMP_FILE.delete()) {
                        logger.log(Level.WARNING, "unable to delete {0}", REQUEST_DUMP_FILE);
                        dumpRequested = false;
                    } else {
                        logger.log(Level.INFO, "found {0}, dumping", REQUEST_DUMP_FILE);
                    }
                }
                String eventId = test == null ? "000" : test.toString();
                boolean bl = hungProcess = System.currentTimeMillis() - this.lastPost > 10000L;
                if (dumpRequested || hungProcess && !eventId.equals(this.reportedEventId)) {
                    if (dumpRequested) {
                        logger.log(Level.INFO, "DUMP REQUESTED, WRITING REPORT TO autoplot_data/log/...\n");
                    } else {
                        logger.log(Level.INFO, "PATHOLOGICAL EVENT QUEUE CLEAR TIME, WRITING REPORT TO autoplot_data/log/...\n");
                    }
                    Date now = new Date();
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
                    String timeStamp = sdf.format(now);
                    if (!DasApplication.hasAllPermission()) {
                        return;
                    }
                    String id = System.getProperty("user.name");
                    this.map.put("USER_ID", id);
                    try {
                        List bis = AboutUtil.getBuildInfos();
                        this.map.put("build_info", bis);
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    int appCount = AppManager.getInstance().getApplicationCount();
                    this.map.put("APP_COUNT", appCount);
                    String s = GuiExceptionHandler.formatReport(this.map, false, "Autoplot detected hang");
                    int hash = this.eventQueue == null ? 1 : GuiExceptionHandler.hashCode(this.eventQueue.getStackTrace());
                    String fname = String.format("hang_%010d_%s_%s.xml", hash, timeStamp, id.replaceAll(" ", "_"));
                    File logdir = LOG_DIR;
                    if (!logdir.exists() && !logdir.mkdirs()) {
                        return;
                    }
                    File f = new File(logdir, fname);
                    try (PrintWriter out = new PrintWriter(new FileOutputStream(f));){
                        out.write(s);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    if (f.setReadable(false, false) && !f.setReadable(true)) {
                        logger.info("unable to set read permissions to owner only");
                    }
                    if (f.setWritable(false, false) && !f.setWritable(true)) {
                        logger.info("unable to set read permissions to owner only");
                    }
                    this.reportedEventId = eventId;
                    this.currentEvent = null;
                }
            }
            this.currentEvent = test;
        };
    }

    public static void main(String[] args) {
        new EventThreadResponseMonitor().start();
    }
}

